/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package calendrier.maree.presentation.navigation

// Used as a Navigation Argument for the WatchDetail Screen.
const val WATCH_ID_NAV_ARGUMENT = "watchId"

/**
 * Represent all Screens (Composables) in the app.
 */
sealed class Screen(
    val route: String
) {
    object Landing : Screen("landing")
    object WatchList : Screen("watchList")
    object WatchListDt : Screen("watchListDt")
    object WatchList3 : Screen("watchList3")
    object WatchDetail : Screen("watchDetail")
    object UserInputComponents : Screen("userInputComponents")
    object Stepper : Screen("stepper")
    object Slider : Screen("slider")
    object Map : Screen("map")
    object DatePicker : Screen("date")
    object Time12hPicker : Screen("time12h")
    object Time24hPicker : Screen("time24h")
    object Dialogs : Screen("dialogs")
    object ProgressIndicators : Screen("progressIndicators")
    object IndeterminateProgressIndicator : Screen("indeterminateProgressIndicator")
    object FullScreenProgressIndicator : Screen("fullScreenProgressIndicator")
    object Theme : Screen("theme")
}
