package com.mybus17000.data

import android.content.Context
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringSetPreferencesKey
import androidx.datastore.preferences.preferencesDataStore
import com.google.android.gms.maps.model.LatLng
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import nl.adaptivity.xmlutil.serialization.*



@Serializable
data class BusLine(
    val id: String,
    val name: String,
    val color: String
)


@Serializable
data class StopResponse(
    val records: List<StopRecord>
)

@Serializable
data class StopRecord(
    val fields: StopFields
)

@Serializable
data class StopFields(
    @SerialName("stop_id") val stop_id: String,
    @SerialName("stop_code") val stop_code: String? = null,
    @SerialName("stop_name") val stop_name: String,
    @SerialName("stop_desc") val stop_desc: String? = null,
    @SerialName("stop_lat") val stop_lat: String,
    @SerialName("stop_lon") val stop_lon: String,
    @SerialName("location_type") val location_type: String? = null,
    @SerialName("parent_station") val parent_station: String? = null
)


val Context.dataStore by preferencesDataStore(name = "favorites_store")

suspend fun saveFavorites(context: Context, favorites: List<String>) {
    val dataStoreKey = stringSetPreferencesKey("favorite_stops")
    context.dataStore.edit { prefs ->
        prefs[dataStoreKey] = favorites.toSet()
    }
}

fun getFavorites(context: Context): Flow<List<String>> {
    val dataStoreKey = stringSetPreferencesKey("favorite_stops")
    return context.dataStore.data.map { prefs ->
        prefs[dataStoreKey]?.toList() ?: emptyList()
    }
}



@Serializable
@XmlSerialName("MonitoredVehicleJourney", "", "")
data class MonitoredVehicleJourney(
    @XmlElement(true)
    val LineRef: String? = null,
    @XmlElement(true)
    val DestinationName: String? = null,
    @XmlElement(true)
    val MonitoredCall: MonitoredCall? = null
)

@Serializable
@XmlSerialName("MonitoredCall", "", "")
data class MonitoredCall(
    @XmlElement(true)
    val ExpectedArrivalTime: String? = null
)

@Serializable
data class StopTimeResponse(
    val records: List<StopTimeRecord>
)

@Serializable
data class StopTimeRecord(
    val fields: StopTimeFields
)

@Serializable
data class StopTimeFields(
    val trip_id: String? = null,
    val arrival_time: String? = null,
    val departure_time: String? = null,
    val stop_id: String? = null
)

@Serializable
data class RoutesLineBusResponse(
    val records: List<RoutesLineBusRecord>
)

@Serializable
data class RoutesLineBusRecord(
    val fields: RoutesLineBus
)
@Serializable
data class RoutesLineBus(
    val route_id: String,
    val agency_id: String? = null,
    val route_short_name: String? = null,
    val route_long_name: String? = null,
    val route_desc: String? = null,
    val route_type: Int? = null,
    val route_color: String? = null,
    val route_text_color: String? = null,
    val route_url: String? = null,
    val route_date_donnee: String? = null
)
@kotlinx.serialization.Serializable
data class ShapeResponse(
    val total_count: Int,
    val records: List<ShapeRecord>
)

@kotlinx.serialization.Serializable
data class ShapeRecord(
    val fields: ShapeFields
)

@kotlinx.serialization.Serializable
data class ShapeFields(
    val shape_id: String,
    val shape_pt_lat: Double,
    val shape_pt_lon: Double,
    val shape_pt_sequence: Int
)

data class RoutePolylineData(
    val points: List<LatLng>,
    val lineName: String,
    val color: String
)

@Serializable
data class TripsResponse(val records: List<TripRecord>)
@Serializable
data class TripRecord(val fields: TripFields)
@Serializable
data class TripFields(val route_id: String, val trip_id: String)

data class BusRoute(
    val totalDuration: Int, // durée totale en minutes
    val numberOfChanges: Int, // nombre de correspondances
    val segments: List<BusSegment>
)

data class BusSegment(
    val lineName: String,
    val fromStop: String,
    val toStop: String,
    val departureTime: String,
    val arrivalTime: String
)
data class RouteSegment(
    val lineName: String,
    val fromStop: String,
    val toStop: String,
    val departureTime: String,
    val arrivalTime : String
)