package com.mybus17000.data.api


import com.mybus17000.data.BusRoute
import com.mybus17000.data.BusSegment
import com.mybus17000.data.RouteSegment
import kotlinx.coroutines.delay
import java.time.LocalDateTime

/**
 * Simulation d'une API de recherche d'itinéraires bus.
 * (On la simulera d’abord localement, puis on la remplacera par un appel HTTP réel, ex : Navitia.io)
 */
object BusRouteApi {

    // Simulation de résultats
    suspend fun getItineraries(
        from: String,
        to: String,
        time: LocalDateTime,
        isArrival: Boolean = false
    ): List<BusRoute> {
        delay(1200) // petite latence simulée

        return listOf(
            BusRoute(
                totalDuration = 32,
                numberOfChanges = 1,
                segments = listOf(
                    BusSegment(
                        lineName = "Ligne 4",
                        fromStop = "Gare Centrale",
                        toStop = "Place des Capucins",
                        departureTime = "08:10",
                        arrivalTime = "08:25"
                    ),
                    BusSegment(
                        lineName = "Ligne 12",
                        fromStop = "Place des Capucins",
                        toStop = "Rue du Tondu",
                        departureTime = "08:28",
                        arrivalTime = "08:42"
                    )
                )
            ),
            BusRoute(
                totalDuration = 41,
                numberOfChanges = 0,
                segments = listOf(
                    BusSegment(
                        lineName = "Ligne 8",
                        fromStop = "Gare Centrale",
                        toStop = "Rue du Tondu",
                        departureTime = "08:05",
                        arrivalTime = "08:46"
                    )
                )
            )
        )
    }
}